
// <![CDATA[

function getStylesDialogElements(columnitem, json2) {
	"use strict";
 let json2b = json2.replace(/---/g, "|");
	let patterns = json2b.split('|');
 let n = patterns.length;  // Anzahl der Elemente
	let s='';
 s += '#wrapperdialog {'+"\n";
 s += ' display: grid;'+"\n";
 s += '	grid-template-columns: ' + columnitem +';'+"\n";
 s += '	grid-template-rows: ';
  // je nach Anzahl die Reihen definieren
 for (let i=0; i<n; i++) {
 	s +='auto ';
 }
 s +="\n";

 s += '	grid-column-gap:70px;'+"\n";
 s += '	grid-row-gap:10px;'+"\n";
 s += '	background-color:red;'+"\n";
 s += '}'+"\n";
 s += '	'+"\n";
 s += '.fbox1 {'+"\n";
 s += ' margin-right:10px;'+"\n";
 s += '}'+"\n";
 s += '	'+"\n";
 s += '.fbox2 {'+"\n";
 s += ' margin-right:10px;'+"\n";
 s += '}'+"\n";
	return s;
}


function createDialogElements(allreadonly, json1, json2) {
	"use strict";
	//alert(json1);
//	alert(json2);

	let customer = JSON.parse(json1);
   // normales replace ersetzt nur den ersten Fall !!
 let json2b = json2.replace(/---/g, "|");
	let patterns = json2b.split('|');
 let n = patterns.length;  // Anzahl der Elemente

	let s='';
 s+=' <div id="wrapperdialog">'+"\n";

 let captions = Object.keys(customer);
 // dialoge
 let index=1;
 let readonly='';
 if (allreadonly) {
   readonly='readonly="readonly"';
	}
 for(var j in customer){
  let str_pat = patterns[index-1]; // hier noch string !!
		//alert(str_pat);
  let pat = JSON.parse(str_pat);
  s+=' <label class="fbox1" for="ui' + index + 'Id">'+pat.caption+'</label>'+"\n";
  if (pat.typ=='number') {
    s+='	<input type="number" class="fbox2" min="'+pat.min+'"  max="'+pat.max+'"  name="' +captions[index-1]+ '" id="ui' +index+ 'Id" '+readonly+' value="'+customer[j]+'"  />'+"\n";
  }
  else if (pat.typ=='text') {
  s+='	<input type="text" class="fbox2" name="' +captions[index-1]+ '" id="ui' +index+ 'Id" '+readonly+'  value="'+customer[j]+'" size="12" />'+"\n";
  }
  else if (pat.typ=='-') {
  s+='	<input type="text" class="fbox2" name="' +captions[index-1]+ '" id="ui' +index+ 'Id" value="'+customer[j]+'" size="12" readonly="readonly" />'+"\n";
  }
  if (pat.typ=='date') {
  s+='	<input type="date" class="fbox2" name="' +captions[index-1]+ '" id="ui' +index+ 'Id" '+readonly+'  '+readonly+'  value="'+customer[j]+'" size="12"  />'+"\n";
  }
  if (pat.typ=='checkbox') {
  s+='	<input type="checkbox" class="fbox2" name="' +captions[index-1]+ '" id="ui' +index+ 'Id" '+readonly+'  value="'+customer[j]+'" size="12"  />'+"\n";
  }

  if (pat.typ=='color') {
  s+='	<input type="color" class="fbox2" name="' +captions[index-1]+ '" id="ui' +index+ 'Id" '+readonly+'  value="'+customer[j]+'" size="12"  />'+"\n";
  }
  if (pat.typ=='datetime') {
  s+='	<input type="datetime" class="fbox2" name="' +captions[index-1]+ '" id="ui' +index+ 'Id" '+readonly+'  value="'+customer[j]+'" size="12"  />'+"\n";
  }
  if (pat.typ=='email') {
  s+='	<input type="email" class="fbox2" name="' +captions[index-1]+ '" id="ui' +index+ 'Id" '+readonly+'  value="'+customer[j]+'" size="12"  />'+"\n";
  }
  if (pat.typ=='month') {
  s+='	<input type="month" class="fbox2" name="' +captions[index-1]+ '" id="ui' +index+ 'Id" '+readonly+'  value="'+customer[j]+'" size="12"  />'+"\n";
  }
  if (pat.typ=='time') {
  s+='	<input type="time" class="fbox2" name="' +captions[index-1]+ '" id="ui' +index+ 'Id" '+readonly+'  value="'+customer[j]+'" size="12"  />'+"\n";
  }
  if (pat.typ=='week') {
  s+='	<input type="week" class="fbox2" name="' +captions[index-1]+ '" id="ui' +index+ 'Id" '+readonly+'  value="'+customer[j]+'" size="12"  />'+"\n";
  }
  if (pat.typ=='password') {
  s+='	<input type="password" class="fbox2" name="' +captions[index-1]+ '" id="ui' +index+ 'Id" '+readonly+'  value="'+customer[j]+'" size="12"  />'+"\n";
  }



  index++;
 }
 s+=' </div>'+"\n";  // wrapperDialog
	return s;
}



function createCompleteDialogElements(caption, captionlegend, allreadonly, columnitem,  clickyes, clickno, json1, json2) {
	"use strict";
		let str_dialogStyles = getStylesDialogElements(columnitem, json1);
		let str_Dialog = createDialogElements(allreadonly, json1, json2);

		let s='';
		s += '  <style type="text/css"  id="internalStyle" >'+"\n";
		s += str_dialogStyles+"\n";
		s += 'fieldset {'+"\n";
		s += '  border: 2px solid #C5D8E1;'+"\n";
		s += '  border-radius: 10px;'+"\n";
		s += '  background: white;'+"\n";
		s += '  margin: 0;'+"\n";
		s += '  width:25rem;'+"\n";
		s += ' }'+"\n";
		s += ' '+"\n";
		s += 'legend { '+"\n";
		s += '  color:red;'+"\n";
		s += ' } '+"\n";
		s += '  </style>'+"\n";

		s += '<h1>'+caption+'</h1>'+"\n";
		s += '<form method="get">'+"\n";
		s += '<fieldset>'+"\n";
		s += '<legend>'+captionlegend+'</legend>'+"\n";

		s+=str_Dialog+"\n";
		s+='</fieldset>'+"\n";
		s+='<br />'+"\n";
		s+='<input type="button" value="Yes" onclick="'+clickyes+'(this.form)" />'+"\n";
		s+='<input type="button" value="No" onclick="'+clickyes+'(this.form)" />'+"\n";
		s+='<input type="reset" value="Reset"   />'+"\n";
		s+='</form>'+"\n";
		s+='<br />'+"\n";
		s+='<br />'+"\n";
		s+='<div id="ajaxerror"></div>'+"\n";	
	 return s;
}

// ]]>