﻿/*
 * basis.java
 *
 * Created on 11. Juni 2006, 19:32
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */




import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;


class basis {
    // Konstanten
    public static final int C_LEER = 1;
    public static final int C_KEINEZAHL = 2;
    public static final int C_ZUKLEIN = 3;
    public static final int C_ZUGROSS = 4;

      // Konstanten f�r den Error Code als String
    public static final String SZ_LEER = "Leerer Text";
    public static final String SZ_KEINEZAHL = "Konvertierung schlug fehl";
    public static final String SZ_ZUKLEIN = "F�r den Bereich zu klein";
    public static final String SZ_ZUGROSS = "F�r den Bereich zu gro�";



    // Damit braucht man nicht die Konstanten aus JOptionPane referenzieren
    public static final int YES = 1;
    public static final int NO = 2;
    public static final int ESC = 3;

    private static int intVal;          // speichert das Ergebnis
    private static long longVal;        // speichert das Ergebnis
    private static double dblVal;       // speichert das Ergebnis

    private static int ValError = 0;   // speichert den Konvertierungfehler


    /**
    * description: Konvertiert einen String in eine int-Variable   
    * Verwendet eine interne Variable zum Speichern des Wertes
    * @see IVal, getValResult
    *
    * @version     1.0  07.07.2002
    * @author      Michael Wilhelm HS Harz, FB AI
    * @param String sText
    * @return int
    * @exception keine
    */
    public static int IntVal(String sText) {
        // erl�uterung von iIVal = Integer.valueOf(szText).intValue();
        String s;
        int intVal;
        s = new String(sText); // neues Objekt
        s = s.trim();  // Leerstellen l�schen
        if (s.length() == 0 ) {
            return 0;
        }
        else {
            try {
                intVal = Integer.valueOf(sText).intValue();
                return intVal;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
    } // IntVal




    /**
    * description: Zeigt eine Fehlermeldung an   
    * @see Message, Yes-No, Yes-No-Esc, Ok-Esc
    *
    * @version     1.0  07.07.2002
    * @author      Michael Wilhelm HS Harz, FB AI
    * @param String sTitle, String sMessage
    * @return keinen
    * @exception keine
    */
  public static void Error( String sTitle, String sMessage) {
    JOptionPane.showConfirmDialog(null,sMessage,sTitle,
      JOptionPane.DEFAULT_OPTION,
      JOptionPane.ERROR_MESSAGE);  // Symbol
    /*  Optionen der Schalter:
         DEFAULT_OPTION    Ok
         YES_NO_OPTION
         YES_NO_CANCEL_OPTION
         OK_CANCEL_OPTION
     */
     /*  Symbole:
      ERROR_MESSAGE
      INFORMATION_MESSAGE
      WARNING_MESSAGE
      QUESTION_MESSAGE
      PLAIN_MESSAGE
     */

  } // Error

    /**
    * description: Zeigt eine Nachricht an   
    * @see Message, Yes-No, Yes-No-Esc, Ok-Esc
    *
    * @version     1.0  07.07.2002
    * @author      Michael Wilhelm HS Harz, FB AI
    * @param String sTitle, String sMessage
    * @return keinen
    * @exception keine
    */
  public static void Message( String sTitle, String sMessage) {
    JOptionPane.showConfirmDialog(null,sMessage,sTitle,
      JOptionPane.DEFAULT_OPTION,
      JOptionPane.INFORMATION_MESSAGE);  // Symbol
    /*  Optionen der Schalter:
         DEFAULT_OPTION    Ok
         YES_NO_OPTION
         YES_NO_CANCEL_OPTION
         OK_CANCEL_OPTION
     */
     /*  Symbole:
      ERROR_MESSAGE
      INFORMATION_MESSAGE
      WARNING_MESSAGE
      QUESTION_MESSAGE
      PLAIN_MESSAGE
     */

  } // Message

    /**
    * description: Zeigt einen Ja-Nein-Dialog   
    * @see Message, Error, Yes-No-Esc, Ok-Esc
    *
    * @version     1.0  07.07.2002
    * @author      Michael Wilhelm HS Harz, FB AI
    * @param String sTitle, String sMessage
    * @return boolean
    * @exception keine
    */
  public static boolean YesNo( String sTitle, String sMessage) {
    int retcode;
    retcode = JOptionPane.showConfirmDialog(null,sMessage,sTitle,
      JOptionPane.YES_NO_OPTION,
      JOptionPane.QUESTION_MESSAGE);  // Symbol

    switch (retcode) {
       case JOptionPane.YES_OPTION:
         // ja, �nderungen speichern
         return true;
       case JOptionPane.NO_OPTION:
         return false;
       case JOptionPane.CANCEL_OPTION:
       default:
         // abbrechen
         return false;
    }
  } // YesNo


    /**
    * description: Zeigt einen Ja-Nein-Abbruch-Dialog   
    * @see Message, Error, Yes-No, Ok-Esc
    *
    * @version     1.0  07.07.2002
    * @author      Michael Wilhelm HS Harz, FB AI
    * @param String sTitle, String sMessage
    * @return int YES_OPTION, NO_OPTION, CANCEL_OPTION
    * @exception keine
    */
  public static int YesNoEsc( String sTitle, String sMessage) {
    int retcode;
    retcode = JOptionPane.showConfirmDialog(null,sMessage,sTitle,
      JOptionPane.YES_NO_CANCEL_OPTION,
      JOptionPane.QUESTION_MESSAGE);  // Symbol

    switch (retcode) {
       case JOptionPane.YES_OPTION:
         // ja, �nderungen speichern
         return YES;
       case JOptionPane.NO_OPTION:
         return NO;
       case JOptionPane.CANCEL_OPTION:
       default:
         return ESC;
    }
  } // YES NO ESC

  
    /**
    * description: Zeigt einen Dialog mit frei definiertem Schalter
    * @see Message, Error, Yes-No, Yes-No-Esc, Ok-Esc
    *
    * @version     1.0  07.07.2002
    * @author      Michael Wilhelm HS Harz, FB AI
    * @param String sTitle, String sMessage, String buttons[]
    * @return int Returncode von JOptionPane
    * @exception keine
    */
  public static int FreeButtons( String sTitle, String sMessage, String buttons[]) {
    int retcode;
    retcode = JOptionPane.showOptionDialog(null, sMessage,sTitle,
           JOptionPane.DEFAULT_OPTION, JOptionPane.QUESTION_MESSAGE, null, buttons, buttons[0]);

    return retcode;
  }  // FreeButtons





    /**
    * description: Zeigt einen Dialog Ok-Esc an
    * @see Message, Error, Yes-No, Yes-No-Esc, Ok-Esc
    *
    * @version     1.0  07.07.2002
    * @author      Michael Wilhelm HS Harz, FB AI
    * @param String sTitle, String sMessage, String buttons[]
    * @return boolean
    * @exception keine
    */
  public static boolean OkEsc( String sTitle, String sMessage) {
    int retcode;
    retcode = JOptionPane.showConfirmDialog(null,sMessage,sTitle,
      JOptionPane.OK_CANCEL_OPTION,
      JOptionPane.INFORMATION_MESSAGE);  // Symbol

    switch (retcode) {
       case JOptionPane.OK_OPTION:
         // ja, �nderungen speichern
         return true;
       case JOptionPane.CANCEL_OPTION:
       default:
         // abbrechen
         return false;
    }
  } // Ok ESC


    /**
    * description: Eingabe eines Strings
    * @see getInput
    *
    * @version     1.0  07.07.2002
    * @author      Michael Wilhelm HS Harz, FB AI
    * @param String sTitle, String sMessage
    * @return String
    * @exception keine
    */
  public static String getInput( String sTitle, String sMessage) {
    return JOptionPane.showInputDialog(null, sTitle, sMessage, 1);
  } // getInput



    /**
    * description: Eingabe eines Strings mit Vorgabe
    * @see getInput
    *
    * @version     1.0  07.07.2002
    * @author      Michael Wilhelm HS Harz, FB AI
    * @param String sTitle, String sMessage, String sInput
    * @return String
    * @exception keine
    */
  public static String getInput( String sTitle, String sMessage, String sInput) {
    return (String) JOptionPane.showInputDialog( null,sMessage, sTitle, JOptionPane.PLAIN_MESSAGE,
       null, null, sInput);
  } // getInput

  



    /**
    * description: gibt einen Klartext f�r die Konvertierung aus
    * @see IVal, LVal, DVal
    *
    * @version     1.0  07.07.2002
    * @author      Michael Wilhelm HS Harz, FB AI
    * @param keine
    * @return String
    * @exception keine
    */
    public static String getErrorCode() {
      switch (ValError) {
        case C_LEER :      return SZ_LEER;
        case C_KEINEZAHL : return SZ_KEINEZAHL;
        case C_ZUKLEIN :   return SZ_ZUKLEIN;
        case C_ZUGROSS :   return SZ_ZUGROSS;
        default:           return "Fehlerhafter Index in Methode getErrorCode: "+Integer.toString(ValError);
      } // switch
    }
    
    
    /**
    * description: �berpr�ft, ob der String eine Integerzahl ist
    * Verwendet eine interne Variable zum Speichern des Wertes
    * @see DVal, LVal, getErrorCode
    *
    * @version     1.0  07.07.2002
    * @author      Michael Wilhelm HS Harz, FB AI
    * @param String sText
    * @return boolean
    * @exception keine
    */
    public static boolean IVal(String sText) {
        // erl�uterung von iIVal = Integer.valueOf(szText).intValue();
        boolean result = true;
        String s;
        s = new String(sText); // neues Objekt
        s.trim();
        if (s.length() == 0) {
            ValError = C_LEER;
            intVal = 0;
            result = false;
        }
        else {
            try {
                intVal = Integer.valueOf(sText).intValue();
                ValError = 0;
            }
            catch (NumberFormatException e) {
                // Check ob die "Zahl" f�r den Integerbereich zu klein oder zu gro�
                // System.err.println(e);
                try {
                    dblVal = Double.valueOf(sText).doubleValue();
                    if ( dblVal<Integer.MIN_VALUE) {
                      ValError = C_ZUKLEIN;
                    }
                    if ( dblVal>Integer.MAX_VALUE) {
                      ValError = C_ZUGROSS;
                    }
                }
                catch (NumberFormatException e2) {
                    // Hier k�nnte noch eine genauere Abfrage integriert werde,
                    // ob die Zahl nicht zu gro� f�r den int-Bereich ist
                    // System.err.println(e);
                    ValError = C_KEINEZAHL;
                    intVal = 0;
                    result = false;
                }
                intVal = 0;
                result = false;
            }
        }
        return result;
    } // IVal



    /**
    * description: gibt den konvertierten Wert aus
    * @see IVal, DVal, LVal, getErrorCode
    *
    * @version     1.0  07.07.2002
    * @author Michael Wilhelm HS Harz, FB AI
    * @param String sText
    * @return String
    * @exception keine
    * @use gibt den Wert der Konvertierung aus
    * @see #setIValError
    * @see #setLValError
    * @see #setDValError
    */
    public static int getIValResult() {
       return intVal;
    }




    /**
    * LVal
    * description: �berpr�ft, ob der String eine Long-Zahl ist
    * Verwendet eine interne Variable zum Speichern des Wertes
    * @see IVal, DVal, getErrorCode
    *
    * @version     1.0  07.07.2002
    * @author      Michael Wilhelm HS Harz, FB AI
    * @param String sText
    * @return boolean
    * @exception keine
    */
    public static boolean LVal(String sText) {
        // erl�uterung von iIVal = Integer.valueOf(szText).intValue();
        boolean result = true;
        String s;
        s = new String(sText); // neues Objekt
        s.trim();
        if (s.length() == 0) {
            ValError = C_LEER;
            longVal = 0;
            result = false;
        }
        else {
            try {
                longVal = Long.valueOf(sText).longValue();
                ValError = 0;
            }
            catch (NumberFormatException e) {
                // Check ob die "Zahl" f�r den Integerbereich zu klein oder zu gro�
                // System.err.println(e);
                try {
                    dblVal = Double.valueOf(sText).doubleValue();
                    if ( dblVal<Long.MIN_VALUE) {
                      ValError = C_ZUKLEIN;
                    }
                    if ( dblVal>Long.MAX_VALUE) {
                      ValError = C_ZUGROSS;
                    }
                }
                catch (NumberFormatException e2) {
                    // Hier k�nnte noch eine genauere Abfrage integriert werde,
                    // ob die Zahl nicht zu gro� f�r den int-Bereich ist
                    // System.err.println(e);
                    ValError = C_KEINEZAHL;
                    longVal = 0;
                    result = false;
                }
                longVal = 0;
                result = false;
            }
        }
        return result;
    } // LVal



    /**
    * description: gibt den konvertierten Wert aus
    * @see IVal, DVal, LVal, getErrorCode
    *
    * @version     1.0  07.07.2002
    * @author Michael Wilhelm HS Harz, FB AI
    * @param keinen
    * @return long
    * @exception keine
    * @use gibt den Wert der Konvertierung aus
    * @see #getIValError
    * @see #setLValError
    * @see #setDValError
    */
    public static long getLValResult() {
       return longVal;
    }



    /**
    * DVal
    * description: �berpr�ft, ob der String eine Double-Zahl ist
    * Verwendet eine interne Variable zum Speichern des Wertes
    * @see IVal, LVal, getErrorCode
    *
    * @version     1.0  07.07.2002
    * @author      Michael Wilhelm HS Harz, FB AI
    * @param String sText
    * @return boolean
    * @exception keine
    */
    public static boolean DVal(String sText) {
        // erl�uterung von iIVal = Integer.valueOf(szText).intValue();
        boolean result = true;
        String s;
        s = new String(sText); // neues Objekt
        s.trim();
        if (s.length() == 0) {
            ValError = C_LEER;
            dblVal = 0;
            result = false;
        }
        else {
            try {
                dblVal = Double.valueOf(sText).doubleValue();
                ValError = 0;
            }
            catch (NumberFormatException e) {
                ValError = C_KEINEZAHL;
                dblVal = 0;
                result = false;
            }
        }
        return result;
    } // DVal



    /**
    * description: gibt den konvertierten Wert aus
    * @see IVal, DVal, LVal, getErrorCode
    *
    * @version     1.0  07.07.2002
    * @author Michael Wilhelm HS Harz, FB AI
    * @param keinen
    * @return double
    * @exception keine
    * @use gibt den Wert der Konvertierung aus
    * @see #getIValError
    * @see #setLValError
    * @see #setDValError
    */
    public static double getDValResult() {
       return dblVal;
    }


    




   
    /**
    * description: konvertiert einen double in einem String
    *              Parameter nk beschreibt die Nachkommastelle       
    *              nk = Anzahl der Nachkommastellen
    * @see IStr2, LStr2
    *
    * @version     1.0  07.07.2002
    * @author Michael Wilhelm HS Harz, FB AI
    * @param double d, int nk
    * @return String
    * @exception keine
    */
    public static String DStr(double d, int nk) {
        java.text.NumberFormat NF = java.text.NumberFormat.getInstance();
        NF.setMinimumFractionDigits(nk);
        NF.setMaximumFractionDigits(nk);
        return NF.format(d);
    }  // DStr

    
    
  /*  BESCHREIBUNG     : konvertiert ein int einen String mit mindestens   */
  /*                     zwei g�ltigen Ziffern                             */
  /*                     12     --->   "12"                                */
  /*                     123    --->   "123"                               */
  /*                     2      --->   "02"                                */
  /*                     1      --->   "01"                                */
  /*                     8      --->   "08"                                */

    /**
    * description: wandelt den int Wert in einen zweistelligen String um 
    *              Example 1 -> 01   123 ->  123
    * @see DStr, LStr2
    *
    * @version     1.0  07.07.2002
    * @author Michael Wilhelm HS Harz, FB AI
    * @param int iZahl
    * @return String
    * @exception keine
    */
    public static String IStr2(int iZahl) {
        String s;
        java.text.NumberFormat NF = java.text.NumberFormat.getInstance();
        s = NF.format(iZahl);
        if (s.length() < 2) s = "0" + s;
        return s;
    }  // IStr2



    /**
    * description: wandelt den long Wert in einen zweistelligen String um 
    *              Example 1 -> 01   123 ->  123
    * @see DStr, Str2
    *
    * @version     1.0  07.07.2002
    * @author Michael Wilhelm HS Harz, FB AI
    * @param long iZahl
    * @return String
    * @exception keine
    */
    public static String LStr2(long lZahl) {
        String s;
        java.text.NumberFormat NF = java.text.NumberFormat.getInstance();
        s = NF.format(lZahl);
        if (s.length() < 2) s = "0" + s;
        return s;
    }  // LStr2


    /**
    * description: konvertiert alle Kommas in einem String
    * @see Point2Komma
    *
    * @version     1.0  07.07.2002
    * @author Michael Wilhelm HS Harz, FB AI
    * @param String sText
    * @return String
    * @exception keine
    */
    public static String Komma2Point(String sText) {
        return sText.replace(',', '.');
    } // siehe Komma2Point



    /**
    * description: konvertiert alle Punkte in einem String
    * @see Komma2Point2
    *
    * @version     1.0  07.07.2002
    * @author Michael Wilhelm HS Harz, FB AI
    * @param String sText
    * @return String
    * @exception keine
    */
    public static String Point2Komma(String sText) {
        return sText.replace('.', ',');
    }



    /**
    * description: konvertiert alle Punkte in einem String
    * log10
    *
    * @version     1.0  07.07.2002
    * @author Michael Wilhelm HS Harz, FB AI
    * @param double x
    * @return double log10
    * @exception keine
    */
    public static double log10(double x) {
        return Math.log(x) / Math.log(10);
    }

    

    
    
    // Datei Methoden

    //   Beispiel
    //   szMom = bas.ChangeFileExt(szUFileName, ".MOM");

    /**
    * description: �ndert die Extention eines Dateinamens (TXT bzw. DAT)
    * @see #CheckFileName
    * @see #getFileExt �ndern der Dateiwerweiterung  TXT  -> DAT
    *
    * @version     1.0  07.07.2002
    * @author Michael Wilhelm HS Harz, FB AI
    * @param String sFileName, String sExt
    * @return String
    * @exception keine
    * @see #CheckFileName
    * @see #ChangeFileExt
    * @see #getFileName extrahiert den Dateinamen ohne Pfad
    * @see #FileExists
    */
    public static String changeFileExt(String sFileName, String sExt) {
        String sErgFile;
        int k;
        sErgFile = "";
        File f = null;
        try {
            // eventuell kann auch f.pathSeparatorChar verwendet werden
            // suche letzten Punkt
            k = sFileName.lastIndexOf(".");
            if (k == -1){ // kein Punkt vorhanden
              return new String(sFileName+sExt);
            }
            else {
              int n = sFileName.length();
                // beginIndex    EndIndex
              sErgFile = sFileName.substring(0,k);  // z�hlt von 0
              return new String(   sErgFile+sExt);
            }

        }
        catch (Exception e) {
        }
        return sErgFile;
    }
    //   Beispiel
    //   szMom = bas.getFileExt(szUFileName);
    //   szMom = ".MOM"




    /**
    * description: holt die Extention eines Dateinamens (TXT bzw. DAT)
    * @see #CheckFileName
    * @see #changeFileExt
    *
    * @version     1.1  31.01.2006
    * @author Michael Wilhelm HS Harz, FB AI
    * @param String sFileName, String sExt
    * @return String
    * @exception keine
    * @see #CheckFileName
    * @see #ChangeFileExt
    * @see #getFileName extrahiert den Dateinamen ohne Pfad
    * @see #FileExists
    */
    // besser mit lastIndexOf(String�str)
    public static String getFileExt(String sFileName) {
        int k, i, n;
        n = sFileName.length();
        // suche von hinten erstes Auftreten eines Punktes
        k = sFileName.lastIndexOf(".");
        if (k == -1) // kein Punkt vorhanden
            return new String("");
        else {
            // substring z�hlt von NULL
            // Anfangsindex   EndIndex
            String s;
            s = sFileName.substring(k, n);
            return sFileName.substring(k, n);
        }
    } // getFileExt
    
    

    /**
    * GetFileNameExt
    * description: holt den Namen und die Extention eines Dateinamens, ohne Pfad
    * @return String Name+Ext
    * @param String sFileName
    * @exception none
    * @version      1.1, 31.01.2006
    * @author Michael Wilhelm HS Harz, FB AI
    * @use Example
    * @see #CheckFileName
    * @see #ChangeFileExt
    * @see #getFileName extrahiert den Dateinamen ohne Pfad
    * @see #FileExists
    */
    public static String getFileNameExt(String sFileName) {
        int k, n;
        n = sFileName.length();
        k = sFileName.lastIndexOf("\\");
        if (k == -1) {
            // test mit /
            k = sFileName.lastIndexOf("/");
            if (k == -1)
                return sFileName;
            else {
                  // beginIndex   endIndex
                return sFileName.substring(k+1, n); // ??????  n-1 ist zu klein            
            }
        }
        else {
              // beginIndex   endIndex
            return sFileName.substring(k+1, n); // ??????  n-1 ist zu klein                        
        }
    }  // getFileNameExt

    
    /**
    * GetFileNameExt
    * description: holt nur den Namen, mit Pfad, ohne Extention
    * @return String Name
    * @param String sFileName
    * @exception none
    * @version      1.1, 31.01.2006
    * @author Michael Wilhelm HS Harz, FB AI
    * @use Example
    * @see #CheckFileName
    * @see #ChangeFileExt
    * @see #getFileNameExt
    * @see #FileExists
    */
    public static String getFileName(String sFileName) {
        int k, i, n;
        n = sFileName.length();
        k = sFileName.lastIndexOf(".");
        if (k == -1)
            return sFileName;
        else
            return sFileName.substring(0, k);  // ohne Punkt
    }  // getFileName

    

    /**
    * FileExists
    * description: pr�ft, ob die Datei existiert
    * @return boolean
    * @param String sFileName
    * @exception none
    * @version      1.1, 31.01.2006
    * @author Michael Wilhelm HS Harz, FB AI
    * @use Example
    * @see #CheckFileName
    * @see #ChangeFileExt
    * @see #getFileNameExt
    */
    public static boolean FileExists(String sFileName) {
        File f = null;
        try {
            // evnetuell kann auch f.pathSeparatorChar verwendet werden
            f = new File(sFileName);
            if (f.exists())
                return true;
            else
                return false;
        }
        catch (Exception e) {
            return false;
        }
    }  // FileExists


    
    

    /**
    * CheckFileName
    * description: Pr�ft, ob die Datei ein g�ltiges Format hat
    * @return boolean 
    * @param String sFileName
    * @exception none
    * @version      1.1, 31.01.2006
    * @author Michael Wilhelm HS Harz, FB AI
    * @use Pr�ft, ob der Dateiname g�ltig ist 
    * @see #getFileName
    * @see #ChangeFileExt
    */
  /*  VERFAHREN        :  Check ob folgende Zeichen vorhanden sind,        */
  /*                      dann falsch                                      */
  /*                      \  /   :  ?  *  "  <  >  |                       */
  /*                      Suche geschieht mit der Methode indexOf          */
  /*                                                                       */
    public static boolean CheckFileName(String sFileName) {
        if (sFileName.length() == 0) {
            return false;
        }
        else {
            int i;
            i = sFileName.indexOf('\\', 0);
            if (i > 0) return false;
            i = sFileName.indexOf('/', 0);
            if (i > 0) return false;
            i = sFileName.indexOf(':', 0);
            if (i > 0) return false;
            i = sFileName.indexOf('?', 0);
            if (i > 0) return false;
            i = sFileName.indexOf('*', 0);
            if (i > 0) return false;
            i = sFileName.indexOf('"', 0);
            if (i > 0) return false;
            i = sFileName.indexOf('<', 0);
            if (i > 0) return false;
            i = sFileName.indexOf('>', 0);
            if (i > 0) return false;
            i = sFileName.indexOf('|', 0);
            if (i > 0) return false;
            return true;
        }
    } //  CheckFileName


    /**
    * centerScreen
    * description: Zentriert das Fenster
    * @return none
    * @param java.awt.Window frame, java.awt.Dimension preset
    * @exception none
    * @version      1.1, 31.01.2006
    * @author Michael Wilhelm HS Harz, FB AI
    */
    public static void centerScreen(java.awt.Window frame, java.awt.Dimension preset) {
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        java.awt.Dimension frameSize;
        if (preset == null)
            preset = frame.getSize();
        if (preset.height > screenSize.height)
            preset.height = screenSize.height;
        if (preset.width > screenSize.width)
            preset.width = screenSize.width;
        // set new pos:
        frame.setBounds((screenSize.width - preset.width) >>1, (screenSize.height - preset.height) >> 1,
            preset.width, preset.height);
    }  // centerScreen



    /**
    * getButton
    * description: Bestimmen, welche Maustaset gedr�ckt wurde Example
    * @return int taste, links=1  mitte=2, rechts=3
    * @param MouseEvent e
    * @exception none
    * @version      1.1, 31.01.2006
    * @author Michael Wilhelm HS Harz, FB AI
    */
    public static int getButton(MouseEvent e) {
        int mode = e.getModifiers();
        if ((mode & e.BUTTON2_MASK) > 0) {
            return 2;
        }
        if ((mode & e.BUTTON3_MASK) > 0) {
            return 3;
        }
        return 1;
    } // getButton


}  // basis

