/*
 * Frame_Select.java
 *
 * Created on 11. Juni 2006, 18:26
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */



import javax.swing.*;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import java.awt.*;

import java.awt.event.*;

import java.sql.*;

import javax.swing.table.*;
import java.util.Vector;




class Frame_Select extends JFrame {
  JLabel lFormel;
  JLabel LErgebnisse;
  JComboBox TSql;
  JToolBar toolBar;
  JButton BnCalc;
  JPanel _tablePanel;
  
  Vector _tableErgs;  // speichert die Tupel
  Vector _tableColumn;  // speichert die Header der Tabelle, zum Einf?gen und Namen

  int _AnzCols;
  int _AnzRows;

  Vector _headerNames;  // speichert die Namen der Attribute
  JTable _tabelle;  // Tabelle

  public Frame_Select() {
        setSize(1000, 600);
        this.setLocation(10, 60);
        this.setTitle("Select");    
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setGUI();
    }
  
  private void setGUI() {
    this.getContentPane().setLayout( new BorderLayout() );

    JToolBar toolBar;
    toolBar = new JToolBar();
   
    BnCalc = new JButton( "Starte SQL" );
    BnCalc.setFont( new Font("Arial", Font.BOLD,28));
    BnCalc.addActionListener(new java.awt.event.ActionListener() {
       public void actionPerformed(ActionEvent e) {
        BnSQL_Start_Click();
       }
    });

    toolBar.add(BnCalc);
    this.getContentPane().add(toolBar, BorderLayout.NORTH);
    
    _tablePanel = new JPanel();
    this.getContentPane().add(_tablePanel, BorderLayout.CENTER);
    _tablePanel.setLayout( new GridBagLayout() );
   
    lFormel = new JLabel("SQL-Befehl");
    lFormel.setFont( new Font("Arial", Font.BOLD,18) );
    _tablePanel.add(lFormel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(20,20,0,0), 0, 6));

      // ComboBox mit Eingabe
    String[] items = new String[7];
    items[0] = "SELECT *  FROM EMP";
    items[1] = "SELECT EMPNO, DEPTNO, SALARY FROM EMP";
    items[2] = "SELECT *  FROM EMP WHERE SALARY > 1300.0";
    items[3] = "SELECT EMPNO, Last_name, DEPTNO, SALARY FROM EMP";
    items[4] = "SELECT * FROM DEPT";
    items[5] = "SELECT * FROM EMP e INNER JOIN DEPT d ON d.deptno=e.deptno";
    items[6] = "SELECT * FROM EMP, DEPT";
    
    TSql = new JComboBox(items);
    TSql.setFont( new Font("Arial", Font.PLAIN,18) );
    _tablePanel.add(TSql,   new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(20,40,0,20), 00, 0));
    TSql.setEditable(true);
    
      // Date init
    _tableErgs = new Vector();
    Vector tupel = new Vector();
    tupel.add("leer");
    _AnzRows = 1;
    _AnzCols = 1;
    _tableErgs.add( tupel );
    _headerNames = new Vector();
    _headerNames.add("leer");
  
    
    LErgebnisse = new JLabel("Ergebnisse:");
    LErgebnisse.setFont( new Font("Arial", Font.PLAIN,18) );
    _tablePanel.add(LErgebnisse,   new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(40,20,0,20), 00, 0));

    _tabelle = createTable();
    _tabelle.setFont( new Font("Monospaced", Font.PLAIN,18) );
    _tabelle.setRowHeight(20);
    // setShowVerticalLines
    // setIntercellSpacing(new Dimension(spacing, spacing)
    JScrollPane scrollpane = new JScrollPane(_tabelle);
    _tablePanel.add(scrollpane,   new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(20,20,0,20), 00, 0));
      
  }  // setGUI
  
      // createTable
  public JTable createTable() {
    // Create a model of the data.
        TableModel dataModel = new AbstractTableModel() {
            // These methods always need to be implemented.
            public int getColumnCount() {
                //System.out.println( " **** AnzCol: "+_tupel.size() );
              return _AnzCols;
            }
            public int getRowCount() {
              return _tableErgs.size();
            }

                // Speicherung mittels Vector und Vector
            public Object getValueAt(int row, int col) {
                Vector tupel = (Vector) _tableErgs.elementAt(row);
                // if (row<2) System.out.println( tupel.elementAt(col) );
                  return tupel.elementAt(col);
            }

            // The default implementations of these methods in
              // AbstractTableModel would work, but we can refine them.
            public String getColumnName(int column) {
                if ( (column+1)<= _headerNames.size() ) {
                    return (String) _headerNames.elementAt(column);
                } else {
                    return "X";
                }
            }
            public Class getColumnClass(int c) {
              return getValueAt(0, c).getClass();
            }
            public boolean isCellEditable(int row, int col) {
              return false;
            }
            /*
            public void setValueAt(Object aValue, int row, int column) {
                System.out.println("Setting value to: " + aValue);
                data[row][column] = aValue;
            }
            */
         };

     _AnzCols=0;  // Extrem Wichtig, damit wird keine Column erzeugt
     JTable table = new JTable(dataModel); // , _TableColModel);

    // Defaulteintrag
    _tableErgs.removeAllElements();
    Vector tupel = new Vector();
    tupel.add("leer");
    _tableErgs.add( tupel );
    _headerNames.removeAllElements();
    _headerNames.add("leer");
     
     _AnzCols=1;
     _tableColumn = new Vector();
     for (int j=0; j<_AnzCols; j++) {
         TableColumn col = new TableColumn(j);
         _tableColumn.add(col);
         table.addColumn(col);
     }

     table.setFont( new Font("Arial", Font.PLAIN,24) );
     table.setRowHeight(30);
     table.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
     table.setAutoCreateColumnsFromModel(true);

     return table;
  } // createTable
  
  
  void BnSQL_Start_Click() {
      try {
        startsql_1();  
      } catch( Exception ex ) {
        System.out.println( ex );
      }    
  }
 

    public void startsql_1()  throws Exception  {
      int i;
      int AnzCols_old;
      String sDbDrv;
      String sDbUrl;

      String sTable="employee";
      String sUsr="sysdba";
      String sPwd="masterkey";

      sDbDrv = "org.firebirdsql.jdbc.FBDriver";
      sDbUrl="jdbc:firebirdsql:localhost/3050:D:\\dbs\\TEST.FDB";

        // Verbindung zur Datenbank, Auslese Variablen
      Connection cn = null;
      Statement  st = null;
      ResultSet  rs = null;

      AnzCols_old = _AnzCols;  // Merken der alten Spalten
      try {        
        // Treiber INIT, Verbinden  und SQL-Statement ausl?sen
        Class.forName( sDbDrv );
        cn = DriverManager.getConnection( sDbUrl, sUsr, sPwd );
        st = cn.createStatement();
      
          // SQL-Statement
        String sql = (String) TSql.getSelectedItem();
        rs = st.executeQuery( sql );

        // Get meta data:
        ResultSetMetaData rsmd = rs.getMetaData();
        _AnzCols = rsmd.getColumnCount();  // neue Felder
        System.out.println("_AnzCols "+_AnzCols);

      
          // Alles l?schen
        _headerNames.removeAllElements();
        _tableErgs.removeAllElements();
        
          // Man braucht den Vektor headerNames, da jetzt noch nicht
         // alle Spalten vorhanden sind.
        for( i=0; i<_AnzCols; i++ ) {   // Attention: first column with 1 instead of 0
          _headerNames.add( rsmd.getColumnName( i+1 ) );
          System.out.println("header("+i+") "+rsmd.getColumnName( i+1 ) );
        }
        
        _AnzRows = 0;
          // Schleife ?ber alle Tupel
        while( rs.next() ) {
            // neue Zeile
          _AnzRows++;
            // Zeile aller Daten
          Vector Tupel = new Vector();
          for( i=0; i<_AnzCols; i++ ) { // Attention: first column with 1 instead of 0
            Tupel.add ( rs.getString( i+1 ) );
          }
            // Tupel zur Gesamtliste hinzuf?gen
          _tableErgs.add( Tupel );
        }
        System.out.println("_AnzRows "+_AnzRows);
        LErgebnisse.setText("Ergebnisse: "+_AnzRows+" Tupel");
        // _tabelle.revalidate();
        
          // Check,, ob neue Spalten da sind
        if (AnzCols_old<_AnzCols) {
          for (int j=AnzCols_old; j<_AnzCols; j++) {
            TableColumn col = new TableColumn(j);
            _tableColumn.add(col);
            _tabelle.addColumn(col);
          }
        }
        else {
          // Check,, ob zuviel Spalten da sind
          if (AnzCols_old>_AnzCols) {
            for (int j=AnzCols_old; j>_AnzCols; j--) {
              TableColumn col = (TableColumn) _tableColumn.elementAt(j-1);
              _tabelle.removeColumn(col);
              _tableColumn.remove(col);
            }
          }
        }

        // setzt die Header-?berschriften
        for (int j=0; j<_AnzCols; j++) {
            String s = (String) _headerNames.elementAt(j);
            TableColumn col = (TableColumn) _tableColumn.elementAt(j);
            col.setHeaderValue(s);
        }

        _tabelle.updateUI();
        

      } catch( Exception ex ) {
        System.out.println( ex );
      } finally {
        try { if( null != rs ) rs.close(); } catch( Exception ex ) {}
        try { if( null != st ) st.close(); } catch( Exception ex ) {}
        try { if( null != cn ) cn.close(); } catch( Exception ex ) {}
      }
    }     // sql
  
}  // class Select



