/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class VierGewinnt
extends JFrame
implements ActionListener {
    private final String ACTION = "creategame";
    private JPanel panelMaingame = null;
    private int numberCols = -1;
    private int numberRows = -1;
    private JPanel panelBn = null;
    private JLabel label1;
    private JLabel label2;
    private JSpinner spNumberColumns = null;
    private JSpinner spNumberRows = null;
    JButtonList[] buttonList = null;
    Color colorPlayer = Color.WHITE;

    public VierGewinnt() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Vier gewinnt");
        this.setSize(770, 600);
        this.setLocation(10, 10);
        this.setGUI();
        this.setVisible(true);
    }

    private void setGUI() {
        this.setLayout(new BorderLayout());
        this.panelBn = new JPanel();
        this.panelBn.setLayout(new FlowLayout());
        this.add((Component)this.panelBn, "North");
        this.label1 = new JLabel("Columns");
        this.panelBn.add(this.label1);
        SpinnerNumberModel model1 = new SpinnerNumberModel(5, 4, 20, 1);
        this.spNumberColumns = new JSpinner(model1);
        this.panelBn.add(this.spNumberColumns);
        this.label2 = new JLabel("Rows");
        this.panelBn.add(this.label2);
        SpinnerNumberModel model2 = new SpinnerNumberModel(5, 4, 20, 1);
        this.spNumberRows = new JSpinner(model2);
        this.panelBn.add(this.spNumberRows);
        JPanel pn = new JPanel();
        pn.setPreferredSize(new Dimension(30, 10));
        this.panelBn.add(pn);
        this.addButton(this.panelBn, "creategame", "creategame");
        this.panelMaingame = new JPanel();
        this.panelMaingame.setBackground(Color.gray);
        this.panelMaingame.setLayout(new BorderLayout());
        this.add((Component)this.panelMaingame, "Center");
        this.setFonts(this.panelBn, 16);
    }

    private void addButton(JPanel panelBn, String caption, String command) {
        JButton bn = new JButton(caption);
        panelBn.add(bn);
        bn.setActionCommand(command);
        bn.addActionListener(this);
    }

    private void setFonts(Container cont, int size) {
        int i = 0;
        while (i < cont.getComponentCount()) {
            Component c = cont.getComponent(i);
            if (c instanceof JPanel) {
                this.setFonts((JPanel)c, size);
            } else {
                c.setFont(new Font("Arial", 1, size));
            }
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd;
        switch (cmd = e.getActionCommand()) {
            case "creategame": {
                this.createGame();
                break;
            }
            default: {
                if (e.getSource() instanceof JButtonList) {
                    JButtonList bn = (JButtonList)e.getSource();
                    bn.click(this.colorPlayer);
                    this.colorPlayer = this.colorPlayer == Color.RED ? Color.BLUE : Color.RED;
                    this.paintAll(this.getGraphics());
                    this.checkGame();
                    this.setButtonBarBackgroundColor(this.colorPlayer);
                    break;
                }
                Basis.ErrorMsgBox("Wrong case in ActionListener", "Error");
            }
        }
    }

    private void setButtonBarBackgroundColor(Color color) {
        this.panelBn.setBackground(color);
        Color c = new Color(color.getRGB() ^ 0xFFFFFF);
        this.label1.setForeground(c);
        this.label2.setForeground(c);
    }

    private void clearGames() {
        this.createGame();
    }

    private void createGame() {
        this.colorPlayer = Color.RED;
        this.setButtonBarBackgroundColor(this.colorPlayer);
        this.numberCols = (Integer)this.spNumberColumns.getValue();
        this.numberRows = (Integer)this.spNumberRows.getValue();
        JPanel panelgame = new JPanel();
        panelgame.setLayout(new GridLayout(this.numberRows + 1, this.numberCols));
        this.buttonList = new JButtonList[this.numberCols];
        int col = 0;
        while (col < this.numberCols) {
            this.buttonList[col] = new JButtonList(Integer.toString(col + 1), col);
            this.buttonList[col].setFont(new Font("Arial", 1, 20));
            panelgame.add(this.buttonList[col]);
            this.buttonList[col].setActionCommand("bn" + col);
            this.buttonList[col].addActionListener(this);
            ++col;
        }
        Cell[] cellsPrevious = new Cell[this.numberCols];
        Cell[] cells = new Cell[this.numberCols];
        int row = 0;
        while (row < this.numberRows) {
            int col2 = 0;
            while (col2 < this.numberCols) {
                Cell cell = new Cell(row, col2);
                panelgame.add(cell);
                if (row == 0) {
                    this.buttonList[col2].cellbottom = cell;
                } else {
                    cellsPrevious[col2].cellbottom = cell;
                    if (col2 > 0) {
                        cellsPrevious[col2 - 1].cellbottomright = cell;
                    }
                    if (col2 < this.numberCols - 1) {
                        cellsPrevious[col2 + 1].cellbottomleft = cell;
                    }
                }
                if (col2 > 0) {
                    cells[col2 - 1].cellright = cell;
                }
                cells[col2] = cell;
                ++col2;
            }
            cellsPrevious = cells;
            cells = new Cell[this.numberCols];
            ++row;
        }
        this.panelMaingame.removeAll();
        this.panelMaingame.add((Component)panelgame, "Center");
        this.paintAll(this.getGraphics());
    }

    private boolean checkCount(String caption, NumbersPlayerChips numbers) {
        if (numbers.getRed() >= 4) {
            this.disableButtons();
            Basis.Messagebox("Gewonnen hat der rote Spieler", caption);
            return true;
        }
        if (numbers.getBlue() >= 4) {
            this.disableButtons();
            Basis.Messagebox("Gewonnen hat der blaue Spieler", caption);
            return true;
        }
        return false;
    }

    private void disableButtons() {
        int col = 0;
        while (col < this.numberCols) {
            this.buttonList[col].setEnabled(false);
            ++col;
        }
    }

    private void checkGame() {
        NumbersPlayerChips numbers;
        JButtonList[] jButtonListArray = this.buttonList;
        int n = this.buttonList.length;
        int n2 = 0;
        while (n2 < n) {
            JButtonList bn = jButtonListArray[n2];
            numbers = bn.checkVertical();
            if (this.checkCount("Gewonnen Spalte", numbers)) {
                return;
            }
            ++n2;
        }
        JButtonList bnHorizontal = this.buttonList[0];
        numbers = bnHorizontal.checkHorizontal();
        if (this.checkCount("Gewonnen Zeile", numbers)) {
            numbers = bnHorizontal.checkHorizontal();
            return;
        }
        JButtonList bnDiagonal1 = this.buttonList[0];
        numbers = bnDiagonal1.checkDiagonale1();
        if (this.checkCount("Gewonnen 1. Diagonale", numbers)) {
            numbers = bnDiagonal1.checkDiagonale1();
            return;
        }
        JButtonList bnDiagonal2 = this.buttonList[this.buttonList.length - 1];
        numbers = bnDiagonal2.checkDiagonale2();
        if (this.checkCount("Gewonnen 2. Diagonale", numbers)) {
            numbers = bnDiagonal2.checkDiagonale2();
            return;
        }
    }

    public static void main(String[] args) {
        new VierGewinnt();
    }
}

