/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class Cell
extends JPanel {
    public int col = -1;
    public int row = -1;
    public Cell cellbottom = null;
    public Cell cellright = null;
    public Cell cellbottomleft = null;
    public Cell cellbottomright = null;
    public Color backgroundColor = Color.WHITE;

    public Cell(int row, int col) {
        this.col = col;
        this.row = row;
        this.setBackground(this.backgroundColor);
        TitledBorder tb = new TitledBorder(LineBorder.createBlackLineBorder());
        this.setBorder(tb);
        this.add(new JLabel(Integer.toString(row * 100 + col)));
    }

    @Override
    public String toString() {
        return "row: " + this.row + "  col: " + this.col;
    }

    public void click(Color color) {
        System.out.println("bn (game): " + this.col);
        this.playgame(color);
    }

    public void playgame(Color color) {
        System.out.println("game cell: row: " + this.row + "  col: " + this.col);
        if (this.cellbottom != null) {
            if (this.cellbottom.backgroundColor == Color.WHITE) {
                this.cellbottom.click(color);
            } else {
                this.checkActuallCell(color);
            }
        } else {
            this.checkActuallCell(color);
        }
    }

    private void checkActuallCell(Color color) {
        if (this.backgroundColor == Color.WHITE) {
            this.backgroundColor = color;
            this.setBackground(this.backgroundColor);
            System.out.println("   set cell with color: row: " + this.row + "  col: " + this.col);
        } else {
            Basis.ErrorMsgBox("The cell has a player chip\nrow: " + this.row + "  col: " + this.col, "Fehler");
        }
    }

    private void addColor(NumbersPlayerChips numbers) {
        System.out.println("addColor: row:" + this.row + "   col:" + this.col);
        if (this.backgroundColor == Color.RED) {
            numbers.incRed();
        } else if (this.backgroundColor == Color.BLUE) {
            numbers.incBlue();
        } else if (this.backgroundColor == Color.WHITE) {
            numbers.incWhite();
        } else {
            Basis.ErrorMsgBox("Falscher else Fall, checkVertical", "Error");
        }
    }

    public NumbersPlayerChips checkVertical() {
        NumbersPlayerChips numbers = this.cellbottom != null ? this.cellbottom.checkVertical() : new NumbersPlayerChips();
        this.addColor(numbers);
        return numbers;
    }

    public NumbersPlayerChips checkHorizontal(boolean firstColumn) {
        NumbersPlayerChips numbers = new NumbersPlayerChips();
        if (this.cellright != null) {
            numbers = this.cellright.checkHorizontal(false);
            this.addColor(numbers);
            if (numbers.getRed() >= 4 || numbers.getBlue() >= 4) {
                return numbers;
            }
        } else {
            numbers = new NumbersPlayerChips();
            this.addColor(numbers);
            return numbers;
        }
        if (firstColumn && this.cellbottom != null) {
            numbers = this.cellbottom.checkHorizontal(true);
        }
        return numbers;
    }

    public NumbersPlayerChips checkDiagonals1(boolean firstColumn) {
        NumbersPlayerChips numbers = new NumbersPlayerChips();
        if (this.cellbottomright != null) {
            numbers = this.cellbottomright.checkDiagonals1(false);
            this.addColor(numbers);
            if (numbers.getRed() >= 4 || numbers.getBlue() >= 4) {
                return numbers;
            }
        } else {
            numbers = new NumbersPlayerChips();
            this.addColor(numbers);
            return numbers;
        }
        if (firstColumn && this.cellbottom != null) {
            numbers = this.cellbottom.checkDiagonals1(true);
        }
        return numbers;
    }

    public NumbersPlayerChips checkDiagonals2(boolean firstColumn) {
        NumbersPlayerChips numbers = new NumbersPlayerChips();
        if (this.cellbottomleft != null) {
            numbers = this.cellbottomleft.checkDiagonals2(false);
            this.addColor(numbers);
            if (numbers.getRed() >= 4 || numbers.getBlue() >= 4) {
                return numbers;
            }
        } else {
            numbers = new NumbersPlayerChips();
            this.addColor(numbers);
            return numbers;
        }
        if (firstColumn && this.cellbottom != null) {
            numbers = this.cellbottom.checkDiagonals2(true);
        }
        return numbers;
    }
}

