﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Windows.Threading;

namespace TestXYGraphics {
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window {

        private XYGraphic graph = new XYGraphic();
        private DispatcherTimer dispatcherTimer;

        public MainWindow() {
            InitializeComponent();
        }

        private void Window_Loaded(object sender, RoutedEventArgs e) {
            graphicPanel.Children.Add(graph);

            dispatcherTimer = new DispatcherTimer();
            dispatcherTimer.Tick += new EventHandler(dispatcherTimer_Tick);
            dispatcherTimer.Interval = TimeSpan.FromMilliseconds(10);
            bnTest1_Click(null, null);
        }

        private void bnTest1_Click(object sender, RoutedEventArgs e) {
            dispatcherTimer.Stop();
            graph.setGraphic("Test1", "X-Achse", "Y-Achse", 0.0, 1.0, 10.0, 0.0, 1.0, 10.0);
            List<XYGraphic.PointXY> coords = new List<XYGraphic.PointXY>();
            coords.Add(new XYGraphic.PointXY(1.5, 2.5));
            coords.Add(new XYGraphic.PointXY(4.5, 7.5));
            coords.Add(new XYGraphic.PointXY(7.7, 2.7));
            graph.setCoords(coords);
            tEditor.Text = graph.ToString();
        }


        private void bnTest2_Click(object sender, RoutedEventArgs e) {
            dispatcherTimer.Stop();
            graph.setGraphic("Test2", "Zeit", "Messwert", 0.0, 0.5, 5.0, 0.0, 2.0, 20.0);
            List<XYGraphic.PointXY> coords = new List<XYGraphic.PointXY>();
            coords.Add(new XYGraphic.PointXY(0.66, 4.5));
            coords.Add(new XYGraphic.PointXY(1.78, 17.5));
            coords.Add(new XYGraphic.PointXY(3.7, 6.7));
            coords.Add(new XYGraphic.PointXY(4.6, 16.9));
            graph.setCoords(coords);
            tEditor.Text = graph.ToString();
        }

        private void bnTest3_Click(object sender, RoutedEventArgs e) {
            dispatcherTimer.Stop();
            graph.setGraphic("Test3", "X", "Y", 0.0, 0.25, 2, 0.0, 0.1, 1.0);
            List<XYGraphic.PointXY> coords = new List<XYGraphic.PointXY>();
            coords.Add(new XYGraphic.PointXY(0.14,0.45));
            coords.Add(new XYGraphic.PointXY(1.67,0.76));
            coords.Add(new XYGraphic.PointXY(1.8,0.98));
            graph.setCoords(coords);
            tEditor.Text = graph.ToString();
        }

        private void bnTest4_Click(object sender, RoutedEventArgs e) {
            dispatcherTimer.Stop();
            graph.setGraphic("Test4", "X", "Y", 0.0, 0.25, 5, -17.0, 1, 1.0);
            double xa = 0.0;
            double xsw = 0.1;
            double xe = 5.0;
            double[] xCoords = new double[51];
            double[] yCoords = new double[51];
            int ii = -1;
            List<XYGraphic.PointXY> coords = new List<XYGraphic.PointXY>();
            XYGraphic.PointXY p;
            for (double x = xa; x <= xe; x += xsw) {
                ii++;
                coords.Add(new XYGraphic.PointXY(x,0.2 * x * x * x - 2.6 * x * x + 5 * x - 2));
            }
            graph.setCoords(coords);
            tEditor.Text = graph.ToString();
        }  // bnTest4_Click

        private void bnTest5_Click(object sender, RoutedEventArgs e) {
            dispatcherTimer.Stop();
            graph.setGraphic("Test5", "X", "Y", 5.0, -0.25, 0, -17.0, 1, 1.0);
            double xa = 0.0;
            double xsw = 0.1;
            double xe = 5.0;
            double[] xCoords = new double[51];
            double[] yCoords = new double[51];
            int ii = -1;
            List<XYGraphic.PointXY> coords = new List<XYGraphic.PointXY>();
            XYGraphic.PointXY p;
            for (double x = xa; x <= xe; x += xsw) {
                ii++;
                coords.Add(new XYGraphic.PointXY(x, 0.2 * x * x * x - 2.6 * x * x + 5 * x - 2));
            }
            graph.setCoords(coords);
            tEditor.Text = graph.ToString();
        }  // bnTest5_Click


        List<XYGraphic.PointXY> coords5 = new List<XYGraphic.PointXY>();
        Random rand = new Random();

        private void bnTest6_Click(object sender, RoutedEventArgs e) {
            graph.setGraphic("Test6", "X-Achse", "Y-Achse", 0.0, 10.0, 100.0, 0.0, 1.0, 10.0);
            tEditor.Text = graph.ToString();
            dispatcherTimer.Start();
        }  

        private void dispatcherTimer_Tick(object sender, EventArgs e)   { 
            // action
            CommandManager.InvalidateRequerySuggested();                        
            if (coords5.Count == 100) {
                coords5.RemoveAt(0);
                for (int i = 0; i < coords5.Count; i++) {
                    coords5[i].x = i;
                }
            }
            double x = coords5.Count;
            double y = rand.Next(0,11);
            coords5.Add(new XYGraphic.PointXY(x, y));
            graph.setCoords(coords5);            
        }

    }
}
