//
//  ViewController.swift
//  iOSGPS
//
//  Created by Michael Wilhelm on 1/05/2016.
//  Copyright © 2016 Michael Wilhelm. All rights reserved.
//

import UIKit
import CoreLocation

class ViewController: UIViewController, CLLocationManagerDelegate {
    
    // uiAttibute
    @IBOutlet var uiLocalisation: UILabel!
    
    @IBOutlet var uiZipcode: UILabel!

    @IBOutlet var uiCountry: UILabel!
    
    @IBOutlet var uiArea: UILabel!
    
    let clLocationManager = CLLocationManager()
    
    // uiEvents
    
    /*
    func reverseGeocodeLocation(_ location: CLLocation,
    completionHandler completionHandler: CLGeocodeCompletionHandler)
    
    typealias CLGeocodeCompletionHandler = ([CLPlacemark]?, NSError?) -> Void
   */
    
    @IBAction func bnGetGPSDatasClick(sender: UIButton) {
        clLocationManager.delegate = self
        clLocationManager.desiredAccuracy = kCLLocationAccuracyNearestTenMeters
        clLocationManager.requestWhenInUseAuthorization()
        clLocationManager.startUpdatingLocation()   // intervall Abfrage !
    }
    
    func locationManager(locManager: CLLocationManager, didUpdateLocations locations: [CLLocation]) {
        CLGeocoder().reverseGeocodeLocation( locManager.location!, completionHandler: {
            (placemarks, error) -> Void in
            
            if error != nil {
                self.uiLocalisation.text = "Fehler bei der Umwandlung der Geokoordianten"
                  + error!.localizedDescription
            }
            else {
                if placemarks!.count > 0 {
                    let clPlacemark = placemarks![0]
                    self.setLocationInformation(clPlacemark)
                    
                }
                else {
                    self.uiLocalisation.text = "Fehlerhafte Daten vom Geocoder"
                }
            }
        })
    }
    
//    func clGeocodeCompletionHandler(clPlacemark: CLPlacemark?, NSError?) {
//    }
    
    func setLocationInformation(clPlacemark: CLPlacemark?) {
        if let placemark = clPlacemark {
            clLocationManager.stopUpdatingLocation()
            uiZipcode.text = (placemark.postalCode != nil) ? placemark.postalCode : ""
            uiCountry.text = (placemark.administrativeArea != nil) ? placemark.administrativeArea : ""
            uiArea.text = (placemark.country != nil) ? placemark.country : ""
        }
    }
    
    func locationManager(manager: CLLocationManager, didFailWithError error: NSError) {
        uiLocalisation.text = "Fehler bei der Umwandlung der Geokoordianten"
            + error.localizedDescription

    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

