﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace testpicture
{
    public partial class Form1 : Form
    {
        private string sFilename = "";
        private bool _bStart = false;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            _bStart = true;
            cbZoom.Items.Clear();
            cbZoom.Items.Add("100 %");
            cbZoom.Items.Add("200 %");
            cbZoom.Items.Add("300 %");
            cbZoom.Items.Add("400 %");
            cbZoom.Items.Add("500 %");
            cbZoom.Items.Add("600 %");
            cbZoom.Items.Add("700 %");
            cbZoom.Items.Add("800 %");
            cbZoom.SelectedIndex = 0;
            _bStart = false;
            Tx.Text = "";
            Ty.Text = "";
         
            pictureBox1.Dock = DockStyle.Fill;
            // CenterImage;  AutoSize;  Normal  StretchImage  Zoom
        }

        private void BnOpen_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog = new OpenFileDialog();
            openFileDialog.DefaultExt = ".bmp";
            openFileDialog.InitialDirectory = System.Environment.CurrentDirectory; //  Environment.GetFolderPath(Environment.SpecialFolder.Personal);
            openFileDialog.Filter =   "JPG-Dateien (*.jpg;*.jpeg)|*.jpg;*.jpeg|" +
                                       "BMP-Dateien (*.bmp)|*.bmp|" +
                                      "PING-Dateien (*.png)|*.png|" +
                                      "GIF-Dateien (*.gif)|*.gif|" +
                                      "Alle Dateien (*.*)|*.*";

            openFileDialog.Multiselect = true;
            openFileDialog.Title = "Bildatei Öffnen";
            if (openFileDialog.ShowDialog(this) == DialogResult.OK)
            {
                sFilename = openFileDialog.FileName;
                pictureBox1.Image = System.Drawing.Image.FromFile(sFilename);
                Graphics g = pictureBox1.CreateGraphics();
                g.DrawImage(pictureBox1.Image,
                    new Rectangle(0, 0, pictureBox1.Width, pictureBox1.Height),  //where to draw the image
                    new Rectangle(0, 0, pictureBox1.Width, pictureBox1.Height),  //the portion of the image to draw
                        GraphicsUnit.Pixel);

                pictureBox1.Update();
                vScrollBar1.Maximum = pictureBox1.Image.Height - pictureBox1.Height + hScrollBar1.Height+1;
                hScrollBar1.Maximum = pictureBox1.Image.Width - pictureBox1.Width + vScrollBar1.Width+1;
                THScroll1.Text = "0";
                TVScroll1.Text = "0";
                hScrollBar1.Value = 0;
                vScrollBar1.Value = 0;
                
                // bmp = new Bitmap(pictureBox1.Image);
            }
            //pictureBox1.ImageLocation = "F:\\cs\\testpicture\\testpicture\\bin\\Debug\\bild1.jpg";
            //pictureBox1.Image = Image.FromFile("F:\\cs\\testpicture\\testpicture\\bin\\Debug\\bild2.jpg");
            //pictureBox1.SizeMode = PictureBoxSizeMode.Normal;
            //pictureBox1.Width = pictureBox1.Image.Width;
            //pictureBox1.Height = pictureBox1.Image.Height;
            //vScrollBar1.Maximum = pictureBox1.Image.Height - Height+60;
            //hScrollBar1.Maximum = pictureBox1.Image.Width - Width+60;
        }


/*
  this.pictureBox1.MouseDown += new System.Windows.Forms.MouseEventHandler(this.pictureBox1_MouseDown);
            this.pictureBox1.MouseMove += new System.Windows.Forms.MouseEventHandler(this.pictureBox1_MouseMove);
 */ 

            //pictureBox1.SizeMode = PictureBoxSizeMode.CenterImage;
            //pictureBox1.SizeMode = PictureBoxSizeMode.AutoSize;
            //pictureBox1.SizeMode = PictureBoxSizeMode.StretchImage;
            //pictureBox1.SizeMode = PictureBoxSizeMode.Zoom;


        private void vhScrollBar1_Scroll(object sender, ScrollEventArgs e)
        {
            int z = cbZoom.SelectedIndex + 1;
            THScroll1.Text = hScrollBar1.Value + "";
            TVScroll1.Text = vScrollBar1.Value + "";

            //Create a graphics object and draw a portion of the image in the PictureBox.
            Graphics g = pictureBox1.CreateGraphics();

            int xWidth = pictureBox1.Width;
            int yHeight = pictureBox1.Height;

            int x;
            int y;

            if (e.ScrollOrientation == ScrollOrientation.HorizontalScroll)
            {
                x = e.NewValue;
                y = vScrollBar1.Value;
            }
            else //e.ScrollOrientation == ScrollOrientation.VerticalScroll
            {
                y = e.NewValue;
                x = hScrollBar1.Value;
            }

            g.DrawImage(pictureBox1.Image,
              new Rectangle(0, 0, xWidth * z, yHeight * z),  //where to draw the image
              new Rectangle(x, y, xWidth, yHeight),  //the portion of the image to draw
              GraphicsUnit.Pixel);

            pictureBox1.Update();

        }



        private void pictureBox1_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button == System.Windows.Forms.MouseButtons.Left)
            {
                Tx.Text = e.X.ToString();
                Ty.Text = e.X.ToString();

            }

        }

        private void pictureBox1_MouseMove(object sender, MouseEventArgs e)
        {
            int z = cbZoom.SelectedIndex + 1;
            // if (!bInsertCoords) return;
            int i = cbZoom.SelectedIndex + 1;
            Tx.Text = (e.X).ToString();
            Ty.Text = (e.Y).ToString();
            Txx.Text = ((e.X / z + hScrollBar1.Value)).ToString();
            Tyy.Text = ((e.Y / z + vScrollBar1.Value)).ToString();
        }

        private void cbZoom_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (_bStart) return;
            int z = cbZoom.SelectedIndex + 1;
            Graphics g = pictureBox1.CreateGraphics();
            g.DrawImage(pictureBox1.Image,
                new Rectangle(0, 0, pictureBox1.Width * z, pictureBox1.Height * z),  //where to draw the image
                new Rectangle(0, 0, pictureBox1.Width, pictureBox1.Height),  //the portion of the image to draw
                    GraphicsUnit.Pixel);

            pictureBox1.Update();
            vScrollBar1.Maximum = pictureBox1.Image.Height * z - pictureBox1.Height + hScrollBar1.Height + 1;
            hScrollBar1.Maximum = pictureBox1.Image.Width * z - pictureBox1.Width + vScrollBar1.Width + 1;
            THScroll1.Text = "0";
            TVScroll1.Text = "0";
            hScrollBar1.Value = 0;
            vScrollBar1.Value = 0;
        }

        private void Form1_ResizeEnd(object sender, EventArgs e)
        {
            if (_bStart) return;
            int z = cbZoom.SelectedIndex + 1;
            Graphics g = pictureBox1.CreateGraphics();
            g.DrawImage(pictureBox1.Image,
                new Rectangle(0, 0, pictureBox1.Width * z, pictureBox1.Height * z),  //where to draw the image
                new Rectangle(0, 0, pictureBox1.Width, pictureBox1.Height),  //the portion of the image to draw
                    GraphicsUnit.Pixel);

            pictureBox1.Update();
            vScrollBar1.Maximum = pictureBox1.Image.Height * z - pictureBox1.Height + hScrollBar1.Height + 1;
            hScrollBar1.Maximum = pictureBox1.Image.Width * z - pictureBox1.Width + vScrollBar1.Width + 1;
            THScroll1.Text = "0";
            TVScroll1.Text = "0";
            hScrollBar1.Value = 0;
            vScrollBar1.Value = 0;
        }




    }
}
