import java.io.*;

public class Test {

    public void test1Write(){
        String filename = "1.bin";
        try {
            FileOutputStream fout = new FileOutputStream(filename);
            DataOutputStream dout = new DataOutputStream(fout);
            int i = 123;
            dout.writeInt(i);
            double d = 123.4567;
            dout.writeDouble(d);
            String s = "ABC";
            dout.writeUTF(s);
            int n = 10;
            dout.writeInt(n); // Anzahl
            for(int j=0;j<n;j++) {
                dout.writeInt(j+2);
            }

            dout.close();
            fout.close();
        }
        catch(IOException e) {
            System.out.println("Error in test1Write");
        }
        System.out.println("ende test1Write");
    }  // test1Write


    public void test1Read(){
        String filename = "1.bin";
        try {
            FileInputStream fin = new FileInputStream(filename);
            DataInputStream din = new DataInputStream(fin);
            int i = 0;
            i = din.readInt();
            System.out.println("i: "+i);

            double d = 0.0;
            d = din.readDouble();
            System.out.println("d: "+d);

            String s = "";
            s = din.readUTF();
            System.out.println("s: "+s);

            System.out.println();
            int n = din.readInt(); // Anzahl
            for(int j=0;j<n;j++) {
                int value = din.readInt();
                System.out.println("value: "+value);
            }

            din.close();
            fin.close();
        }
        catch(IOException e) {
            System.out.println("Error in test1Read");
        }
        System.out.println("ende test1Read");
    }      // test1Read


    public void test2Write(boolean buffered){
        String filename = "2.bin";
        try {
            System.out.println("in test2Write");
            FileOutputStream fout = new FileOutputStream(filename);
            DataOutputStream dout=null;
            if (buffered) {
                BufferedOutputStream bout = new BufferedOutputStream(fout);
                dout = new DataOutputStream(bout);
            }
            else {
                dout = new DataOutputStream(fout);
            }

            long t1,t2;
            t1 = System.currentTimeMillis();
            for (int j=0; j<1000000; j++) {
                int i = 123+j;
                double d = 123.4567+j;
                String s = "ABC";
                dout.writeInt(i);
                dout.writeDouble(d);
                dout.writeUTF(s);
            }
            dout.close();
            fout.close();
            t2 = System.currentTimeMillis();
            System.out.println("Zeit: "+(t2-t1));
        }
        catch(IOException e) {
            System.out.println("Error in test2Write");
        }
        System.out.println("ende test2Write");
    }  // test2Write


    public void test2Read(boolean buffered){
        String filename = "2.bin";
        try {
            System.out.println("in test2Read");
            FileInputStream fin = new FileInputStream(filename);
            DataInputStream din =null;
            if (buffered) {
                BufferedInputStream bin = new BufferedInputStream(fin);
                din = new DataInputStream(bin);
            }
            else {
                din = new DataInputStream(fin);
            }

            long t1,t2;
            t1 = System.currentTimeMillis();
            for (int j=0; j<1000000; j++) {
                int i = din.readInt();
                //System.out.println("i: "+i);

                double d = din.readDouble();
                //System.out.println("d: "+d);

                String s = din.readUTF();
                //System.out.println("s: "+s);
            }
            din.close();
            fin.close();
            t2 = System.currentTimeMillis();
            System.out.println("Zeit: "+(t2-t1));
        }
        catch(IOException e) {
            System.out.println("Error in test2Read");
        }
        System.out.println("ende test2Read");
    }  // test2Read
}
