import java.io.*;
import java.util.ArrayList;
import java.util.List;

public class Test {
    public void test_FileOutputStream() {
        try {
            FileOutputStream fout = new FileOutputStream("1.txt");
            fout.write(65);
            fout.write(66);
            fout.write(67);
            fout.write(13);
            fout.write(10);
            fout.write(97);
            fout.write(98);
            fout.close();
        }
        catch (IOException e) {
            System.err.println("IOException: " + e);
        }
    }
    public void test_Printstream() {
        try {
            FileOutputStream fout = new FileOutputStream("2.txt");
            PrintStream ps = new PrintStream(fout);
            ps.println(42);
            int b = 43;
            ps.println(b);
            ps.println(42.123456789);
            ps.print("Hallo: ");
            ps.println("Erstmal");
            ps.close();
            fout.close();
        }
        catch (IOException e) {
            System.err.println("IOException: " + e);
        }
    }



    private List<String> testBufferedReader(String filename) {
        List<String> lines = new ArrayList<>(1000000);
        long t1, t2;
        t1 =  System.currentTimeMillis();
        try {
            FileInputStream fin = new FileInputStream(filename);
            InputStreamReader iin = new InputStreamReader(fin);
            BufferedReader din = new BufferedReader(iin);
            while (din.ready()) {
                lines.add( din.readLine() );
            }
            din.close();
            iin.close();
            fin.close();
        } catch (FileNotFoundException e) {
            System.out.println("Datei nicht vorhanden:\n" + filename);
            e.printStackTrace();
        } catch (IOException e) {
            System.out.println("Fehler beim Lesen der Datei:\n" + filename);
            e.printStackTrace();
        }
        t2 =  System.currentTimeMillis();
        System.out.println("testBufferedReader, Zeit: "+(t2-t1) );
        return lines;
    }  // testBufferedReader

    public void testRead(String filename) {
        List<String> lines = testBufferedReader(filename);
        for(String line : lines){
            System.out.println(line);
        }
    }
}
